/*
	MSICustomActionElevator

	This application sets the bit on the Type field for a custom action to run
	under elevated privileges

	Parameters:  [-w] MSIDatabaseFileName CustomActionFileName

	If you put in the -w, the app will wait for a key before closing

	Copyright 2007, Jason Terando
	You can use this for any commercial or non-commercial purposes.  No warranty is
	implied - use at your own risk.
*/

#include "stdafx.h"
#include <windows.h>
#include <msi.h>
#include <msiquery.h>
#include <iostream>
#include <conio.h>

using namespace std;

MSIHANDLE hInstall = NULL, hView = NULL, hRecord = NULL;
bool Wait = false;
LPCWSTR DatabaseFileName = L"";
LPCWSTR CustomActionFileName = L"";

// Clean up when we are done
void Shutdown(int ExitCode) {
	if(hRecord != NULL) {
		MsiViewClose(hRecord);
	}
	
	if(hView != NULL) {
		MsiViewClose(hView);
	}

	if(hInstall != NULL) {
		MsiViewClose(hInstall);
	}

	if(Wait) {
		wprintf(L"Press any key to exit...");
		while(_kbhit() == 0) {
		}
	}

	exit(ExitCode);
}

// Main routine
int _tmain(int argc, _TCHAR* argv[])
{
	UINT result;
	WCHAR FileID[128] = {0};

	if(argc < 2) {
		wprintf(L"Usage [-w] MSIDatabaseFileName CustomActionFileName\n    -w = Wait for keypress at completion\n   Press any key...\n");
		while(_kbhit() == 0);
		exit(-1);
	}

	int i = 1;
	if(wcsicmp(argv[1], L"-w") == 0) {
		Wait = true;
		i = 2;
	}

	DatabaseFileName = argv[i++];
	CustomActionFileName = argv[i];
	
	wprintf(L"Opening \"%s\"\n", DatabaseFileName);

	result = MsiOpenDatabase(DatabaseFileName, MSIDBOPEN_DIRECT, & hInstall);
	if(result != ERROR_SUCCESS) {
		fwprintf(stderr, L"Unable to open database: 0x%08X\n", 
			DatabaseFileName, result);
		Shutdown(-1);
	}

	// Find our custom action in the file table
	wprintf(L"Searching file table for \"%s\"\n", CustomActionFileName);
	result = MsiDatabaseOpenView(hInstall, 
		L"SELECT `File`, `FileName` FROM `File`",
		& hView);
	if(result != ERROR_SUCCESS) {
		fwprintf(stderr, L"Unable to open file table: 0x08X\n", result);
		Shutdown(-2);
	}

	result = MsiViewExecute(hView, 0);
	if(result != ERROR_SUCCESS) {
		fwprintf(stderr, L"Unable to view file table: 0x08X", result);
		Shutdown(-3);
	}

	// Locate the file record matching our custom action
	while((result = MsiViewFetch(hView, & hRecord)) == ERROR_SUCCESS) {
		WCHAR FileName[_MAX_PATH];
		DWORD dw = _MAX_PATH;
		MsiRecordGetString(hRecord, 2, FileName, & dw);
		if(dw > 0) {
			WCHAR * ptr = wcsstr(FileName, CustomActionFileName);
			if(ptr != NULL) {
				dw = _MAX_PATH;
				MsiRecordGetString(hRecord, 1, FileID, & dw);
				break;
			}
		}
		MsiViewClose(hRecord);
	}
	MsiViewClose(hView);

	// If we could not find the file, exit
	if(FileID[0] == 0) {
		fwprintf(stderr, L"Unable to locate custom action in file table\n", 
			CustomActionFileName);
		Shutdown(-4);
	}

	// Get the custom action table entries for our file
	wprintf(L"Searching custom action table for matches\n");
	WCHAR query[256];
	swprintf_s(query, 256, 
		L"SELECT Action, Type, Target FROM CustomAction WHERE Source='%s'",
		FileID);
	result = MsiDatabaseOpenView(hInstall, query, & hView);
	if(result != ERROR_SUCCESS) {
		fwprintf(stderr, L"Unable to open custom action table: 0x08X\n", result);
		Shutdown(-5);
	}

	result = MsiViewExecute(hView, 0);
	if(result != ERROR_SUCCESS) {
		fwprintf(stderr, L"Unable to view custom action table: 0x08X", result);
		Shutdown(-6);
	}

	bool needCommit = false;
	while((result = MsiViewFetch(hView, & hRecord)) == ERROR_SUCCESS) {
		WCHAR id[100];
		int type;
		WCHAR target[1024];

		DWORD dw = 100;
		MsiRecordGetString(hRecord, 1, id, & dw);
		type = MsiRecordGetInteger(hRecord, 2);
		dw = 1024;
		MsiRecordGetString(hRecord, 3, target, & dw);

		if((type & 0x800) == 0x800) {
			wprintf(L"%s is already privileged\n", target);
		} else {
			int newType = type | 0x800;
			wprintf(L"Updating type from %04X to %04X for %s\n", 
				type, newType, target);
			needCommit = true;
			result = MsiRecordSetInteger(hRecord, 2, newType);
			MsiViewModify(hView, MSIMODIFY_UPDATE, hRecord);
			if(result != ERROR_SUCCESS) {
				fwprintf(stderr, L"Unable to update record: 0x08X", result);
				Shutdown(-7);
			}
		}
		MsiViewClose(hRecord);
	}

	// Commit changes if we made any
	if(needCommit) {
		wprintf(L"Committing changes\n");
		result = MsiDatabaseCommit(hInstall);
		if(result != ERROR_SUCCESS) {
			fwprintf(stderr, L"Unable to commit database changes: 0x08X", result);
			Shutdown(-8);
		}
	}

	Shutdown(0);
}

